<?php
  // Initialize the session
  session_start();
  // Set Language variable
  if(isset($_GET['lang']) && !empty($_GET['lang'])){
    $_SESSION['lang'] = $lang = $_GET['lang'];
  }
  else{
    $_SESSION['lang'] = $lang =  "en";
  }
  // Include Language file
  if(isset($_SESSION['lang'])){
    include "../lang/lang_".$_SESSION['lang'].".php";
  }else{
    include "../lang/lang_en.php";
  }   
  // Check if the user is already logged in, if yes then redirect him to welcome page
  if(isset($_SESSION["staff_loggedin"]) && $_SESSION["staff_loggedin"] === true){
    header("location: dashboard.php?lang=$lang");
    exit;
  }   
  // Include config file
  require_once "../connect.php";   
  // Define variables and initialize with empty values
  $username = $password = "";
  $username_err = $password_err = "";   
  // Processing form data when form is submitted
  if($_SERVER["REQUEST_METHOD"] == "POST"){ 
    // Check if username is empty
    if(empty(trim($_POST["username"]))){
      $username_err = _username_err;
    }else{
      $username = trim($_POST["username"]);
    }    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){
      $password_err = _password_err ;
    } else{
      $password = trim($_POST["password"]);
    }    
    // Validate credentials
    if(empty($username_err) && empty($password_err)){
      // Prepare a select statement
      $sql = "SELECT user_id, comp_id,  username, password FROM login WHERE username = ?";        
      if($stmt = mysqli_prepare($conn, $sql)){
        // Bind variables to the prepared statement as parameters
        mysqli_stmt_bind_param($stmt, "s", $param_username);            
        // Set parameters
        $param_username = $username;
        // Attempt to execute the prepared statement
        if(mysqli_stmt_execute($stmt)){
          // Store result
          mysqli_stmt_store_result($stmt);                
          // Check if username exists, if yes then verify password
          if(mysqli_stmt_num_rows($stmt) == 1){                    
            // Bind result variables
            mysqli_stmt_bind_result($stmt, $id, $comp_id,  $username,  $hashed_password);
            if(mysqli_stmt_fetch($stmt)){
              if(password_verify($password, $hashed_password)){
                // Password is correct, so start a new session
                session_start();                            
                // Store data in session variables
                $_SESSION["staff_loggedin"] = true;
                $_SESSION["staffi_id"] = $id;
                $_SESSION["username"] = $username;
                $_SESSION['staff_company_id'] = $comp_id;
                $lang = $_SESSION['lang'];                            
                // Redirect user to welcome page
                header("location: dashboard.php?lang=$lang");
              } else{
                // Display an error message if password is not valid
                $password_err = _password_err2 ;
              }
            }
          } else{
            // Display an error message if username doesn't exist
            $username_err = _username_err2 ;
          }
        } else{
          echo _login_error;
        }
      }        
      // Close statement
      mysqli_stmt_close($stmt);
    }    
    // Close connection
    mysqli_close($conn);
  }
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>SMS | Login</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="../tools/bower_components/bootstrap/dist/css/bootstrap.min_<?= $_SESSION['lang'];?>.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../tools/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="../tools/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="../tools/dist/css/AdminLTE.min_<?= $_SESSION['lang'];?>.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="../tools/plugins/iCheck/square/blue.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="../tools/bower_components/select2/dist/css/select2.min.css">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <!-- Google Font -->
    <script>
      function changeLang(){
        document.getElementById('form_lang').submit();
      }
    </script>
    <meta name="robots" content="noindex, nofollow">
  </head>
  <body class="hold-transition login-page"> 
    <div class="login-box">
      <!-- Language -->
      <!-- <form style=" margin-bottom: 26px; <?php if($_SESSION['lang']=="ar") {?> direction: rtl; <?php }?>" method='get' action='' id='form_lang'>
        <select class="form-control select3"  onchange='changeLang();' style="width: 100%; " name='lang'>
          <option value='ar' <?php if(isset($_SESSION['lang']) && $_SESSION['lang'] == 'ar'){ echo "selected"; } ?> >العربية</option>
          <option value='en' <?php if(isset($_SESSION['lang']) && $_SESSION['lang'] == 'en'){ echo "selected"; } ?> >English</option>
          <option value='fr' <?php if(isset($_SESSION['lang']) && $_SESSION['lang'] == 'fr'){ echo "selected"; } ?> >Français</option>              
        </select>                  
      </form> -->
      <div class="login-logo">
        <img src="../images/nz_logo.jpg">
      </div>
      <!-- /.login-logo -->
      <div class="login-box-body">
        <p class="login-box-msg"> <?= _login_title ?></p>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
          <div class="form-group has-feedback <?php echo (!empty($username_err)) ? 'has-error' : ''; ?>">
            <input type="text" class="form-control" placeholder="<?= _username ?>" name="username" value="<?php echo (!empty($username)) ? $username : ''; ?>" >
            <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
            <span class="help-block"><?php echo $username_err; ?></span>
          </div>
          <div class="form-group has-feedback <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
            <input type="password" class="form-control" placeholder="<?= _passowrd ?>" name="password" >
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
            <span class="help-block"><?php echo $password_err; ?></span>
          </div>
          <div class="row">
            <div class="col-xs-8">
              <div class="checkbox icheck">
                <label>
                  <input type="checkbox"><?= _rememberMe ?> 
                </label>
              </div>
            </div>
            <!-- /.col -->
            <div class="col-xs-4">
              <button type="submit" class="btn btn-primary btn-block btn-flat" name="submit"><?= _enter ?></button>
            </div>
            <!-- /.col -->
          </div>
        </form> 
        <a href="#" ><?= _forget ?></a><br>
      </div>
      <!-- /.login-box-body -->
    </div>
    <!-- /.login-box -->
    <!-- jQuery 3 -->
    <script src="../tools/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap 3.3.7 -->
    <script src="../tools/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- iCheck -->
    <script src="../tools/plugins/iCheck/icheck.min.js"></script>
    <!-- Select2 -->
    <script src="../tools/bower_components/select2/dist/js/select2.full.min.js"></script>
    <script>
      $(function () {
        $('input').iCheck({
          checkboxClass: 'icheckbox_square-blue',
          radioClass: 'iradio_square-blue',
          increaseArea: '20%' /* optional */
        });
        $('.select2').select2()
        <?php include("lang.php");?>
      });
    </script>
  </body>
</html>